# **The Russian Blackmailer \- Write-up**

## **Challenge Overview**

In this OSINT-focused challenge, we need to investigate a blackmail attempt that went wrong when the perpetrator accidentally included information in their video that could reveal their identity and location. Our goal is to analyze the provided evidence and determine the blackmailer's full name and home address.

## **Evidence Provided**

1. `Evidence_1.eml` \- The initial blackmail email  
2. `Evidence_2.eml` \- Follow-up email claiming it was a joke  
3. `Proof.mp4` \- Video attachment that contains hidden clues

## **Solution Path**

### **Step 1: Analyze the Video for Location Data**

The first key piece of evidence is in the video file. We need to identify the pub shown in the footage.

* The pub is **The Sugarmill Pub** located in **Bourne**  
* This gives us our first geographical point of reference

### **Step 2: Translate the Russian Speech**

The video contains Russian dialogue that needs to be translated:

```
"Этот пирог очень-очень хорошо, думаю, я должен оставить отзыв в интернете, да, люди должны знать, насколько это хорошо."
```

Translation:

```
"This pie is very, very good, I think I should leave a review online, yes, people should know how good it is."
```

This dialogue gives us a crucial clue \- the person intends to leave an online review of the establishment.

### **Step 3: Find the Online Reviews**

Based on the dialogue, we need to search for reviews left for The Sugarmill Pub by someone with a Russian name. We should specifically look for:

* Reviews on **Restaurant Guru**  
* Reviews on **TripAdvisor**  
* (There's also a mention of a Google review, but it's noted as "not visible at present")

Search for reviews left by **Evgenil Kuznetsova** on these platforms.

### **Step 4: Investigate the Reviewer's Online Presence**

From the reviews found in Step 3, we can determine that:

* The blackmailer uses the name **Evgenil Kuznetsova**  
* Both the TripAdvisor and Google reviews reveal a Mastodon username associated with this person

### **Step 5: Locate the Mastodon Profile and Find the Home Address**

* Find the Mastodon profile for Evgenil Kuznetsova  
* Look for any posts where they might have shared their location or address  
* According to the documentation, they have declared a property as their house  
* Geo-locate this property to find the address: **11 Kestrel Drive**

## **Final Answer**

According to the answer format provided in the instructions, the flag is:

```
{Evgenil_Kuznetsova_11_Kestrel_Drive}
```

## **Verification**

The answer format follows the example given in the briefing, where the flag contains the full name and address with underscores between words and enclosed in curly braces.

## **Additional Notes**

* The documentation suggests a potential Russian State connection, but this appears to be narrative flavor rather than a necessary clue for solving the challenge  
* The challenge primarily tests OSINT skills, focusing on location identification, language translation, and tracking digital footprints across multiple platforms

